<?php
/***
 * Setup of Frontpage Slider
 *
 * Registers the Custom Post Type Frontpage Slider and add custom Metaboxes
 * as well as Ordering Options to the new post type. 
 * Also embeds all CSS and JS files needed for FlexSlider. 
 *
 * Frontpage Slider is based on jQuery FlexSlider v2.0 | GPLv2 licensed
 * http://www.woothemes.com/flexslider/
 *
 */
 
 
// Get Theme Options
$options = get_option('zeefocus_options');

// Check if Frontpage Slider is activated in Theme Options
if(isset($options['themeZee_frontpage_image_source']) and $options['themeZee_frontpage_image_source'] == "slideshow" ) :
	
	
	/* Slider Setup
	-------------------------------------------------------------- */
	
	// Register new custom post type for the slideshow
	add_action('init', 'themezee_register_frontpage_slider_post_type');
	function themezee_register_frontpage_slider_post_type()
	{
		register_post_type('frontpage_slider', array(
			'label' => __('Frontpage Slider', 'zeeFocusPro_language'),
			'public' => true,
			'show_ui' => true,
			'menu_position' => 6,
			'has_archive' => false,
			'rewrite' => array('slug'=>'slide'),
			'supports' => array('thumbnail', 'title', 'page-attributes')
			) 
		);
	}
	
	
	/* Slider Metaboxes
	-------------------------------------------------------------- */

	// Change headings of default metaboxes in the Frontpage Slider screen
	add_action('do_meta_boxes', 'themezee_frontpage_slider_edit_metaboxes');
	function themezee_frontpage_slider_edit_metaboxes() {
		
		// Remove default metaboxes
		remove_meta_box( 'postimagediv', 'frontpage_slider', 'side' );
		remove_meta_box( 'pageparentdiv', 'frontpage_slider', 'side' );
		
		/* Add removed meta boxes with changed headings */
		add_meta_box('postimagediv', __('Slide Image', 'zeeFocusPro_language' ), 'post_thumbnail_meta_box', 'frontpage_slider', 'advanced', 'low');
		add_meta_box('pageparentdiv', __('Slide Order', 'zeeFocusPro_language' ), 'page_attributes_meta_box', 'frontpage_slider', 'side', 'low');
	}
	
	// Add Slide Link metabox
	add_action( 'add_meta_boxes', 'themezee_frontpage_slider_add_slide_link_metabox' );
	function themezee_frontpage_slider_add_slide_link_metabox() {
		add_meta_box( 'themezee_slider_link_metabox', __( 'Slide Link', 'zeeFocusPro_language' ), 'themezee_frontpage_slider_link_metabox', 'frontpage_slider', 'normal', 'default' );
	}
	
	// HTML Output of Slide Link metabox */     
	function themezee_frontpage_slider_link_metabox() {
		global $post;	
				 
		/* Retrieve the metadata values if they already exist. */
		$slide_link_url = get_post_meta( $post->ID, 'slide_link_url', true ); ?>
		
		<p><?php echo _e('URL: ', 'zeeFocusPro_language'); ?><input type="text" style="width: 90%;" name="slide_link_url" value="<?php echo esc_attr( $slide_link_url ); ?>" /></p>
		<span class="description"><?php _e('The URL this slide should link to.', 'zeeFocusPro_language' ); ?></span>
	<?php 
	}
	
	// Save Metabox Function
	add_action( 'save_post', 'themezee_frontpage_slider_save_slide_link', 1, 2 );
	function themezee_frontpage_slider_save_slide_link( $post_id, $post ) {
		if ( isset( $_POST['slide_link_url'] ) ) {
			update_post_meta( $post_id, 'slide_link_url', esc_url( $_POST['slide_link_url'] ) );
		}
	}


	/* Slider Order Column
	-------------------------------------------------------------- */
	
	// Add order column to frontpage_slider post type
	add_action('manage_edit-frontpage_slider_columns', 'themezee_add_frontpage_slider_column');
	function themezee_add_frontpage_slider_column($frontpage_slider_columns) {
		$frontpage_slider_columns['menu_order'] = "Order";
		return $frontpage_slider_columns;
	}

	// Show custom order column values
	add_action('manage_frontpage_slider_posts_custom_column','themezee_show_frontpage_slider_order');
	function themezee_show_frontpage_slider_order($name){
		global $post;
		if($name == 'menu_order') :
			$order = $post->menu_order;
			echo $order;
		endif;
	}

	// Make column sortable
	add_filter('manage_edit-frontpage_slider_sortable_columns','themezee_make_frontpage_slider_order_sortable');
	function themezee_make_frontpage_slider_order_sortable($columns){
		$columns['menu_order'] = 'menu_order';
		return $columns;
	}
	
	
endif;

?>