<?php
	
	function themezee_sections_general() {
		$themezee_sections = array();
		
		$themezee_sections[] = array("id" => "themeZee_general_header",
					"name" => __('Header Settings', 'zeeFocusPro_language'));
					
		$themezee_sections[] = array("id" => "themeZee_general_layout",
					"name" => __('Layout Settings', 'zeeFocusPro_language'));
					
		$themezee_sections[] = array("id" => "themeZee_general_css_section",
					"name" => __('Custom CSS Code', 'zeeFocusPro_language'));
					
		return $themezee_sections;
	}
	
	function themezee_settings_general() {

		$themezee_settings = array();
	
		### HEADER SETTINGS
		#######################################################################################
		$themezee_settings[] = array("name" => __('Logo Image', 'zeeFocusPro_language'),
						"desc" => __('Paste the full Image URL of your logo or click Upload Image. Leave this field blank to display the site title instead of a logo image.', 'zeeFocusPro_language'),
						"id" => "themeZee_general_logo",
						"std" => "",
						"type" => "image",
						"section" => "themeZee_general_header");

		$themezee_settings[] = array("name" => __('Show Tagline?', 'zeeFocusPro_language'),
						"desc" => __('Check this if you want to show your tagline(blog description) below the logo', 'zeeFocusPro_language'),
						"id" => "themeZee_general_tagline",
						"std" => "true",
						"type" => "checkbox",
						"section" => "themeZee_general_header");
						
		$themezee_settings[] = array("name" => __('Header displays', 'zeeFocusPro_language'),
						"desc" => __('Select which content is displayed in the right handed header area.', 'zeeFocusPro_language'),
						"id" => "themeZee_general_header_content",
						"std" => 'nothing',
						"type" => "radio",
						'choices' => array(
									'nothing' => __('Nothing', 'zeeFocusPro_language'),
									'search' => __('Search Form', 'zeeFocusPro_language'),
									'ads' => __('468x60px Banner Ad (see Ads tab)', 'zeeFocusPro_language'),
									'text' => __('Text Line (add content below)', 'zeeFocusPro_language'),
									'social' => __('Social Media Icons (see Social Media tab)', 'zeeFocusPro_language')),
						"section" => "themeZee_general_header"
						);
						
		$themezee_settings[] = array("name" => __('Header Text Line', 'zeeFocusPro_language'),
						"desc" => __('Enter a textline which can be displayed in the header area (see option above).', 'zeeFocusPro_language'),
						"id" => "themeZee_general_header_content_text",
						"std" => "",
						"type" => "text",
						"section" => "themeZee_general_header");
						
		### LAYOUT SETTINGS
		#######################################################################################				
		$themezee_settings[] = array("name" => __('Default Page Header Title', 'zeeFocusPro_language'),
						"desc" => __('Enter here the page header title which is displayed on single blog post and blog index pages.', 'zeeFocusPro_language'),
						"id" => "themeZee_general_page_header",
						"std" => "Blog: Latest News",
						"type" => "text",
						"section" => "themeZee_general_layout");
						
		$themezee_settings[] = array("name" => __('Sidebar Options', 'zeeFocusPro_language'),
						"desc" => "",
						"id" => "themeZee_general_sidebars",
						"std" => 'right',
						"type" => "radio",
						'choices' => array(
									'left' => __('Left Sidebar', 'zeeFocusPro_language'),
									'right' => __('Right Sidebar', 'zeeFocusPro_language')),
						"section" => "themeZee_general_layout"
						);
						
		$themezee_settings[] = array("name" => __('Hide Credit Link?', 'zeeFocusPro_language'),
						"desc" => __('Check this if you want to hide the credit link to themezee.com', 'zeeFocusPro_language'),
						"id" => "themeZee_show_credit_link",
						"std" => "false",
						"type" => "checkbox",
						"section" => "themeZee_general_layout");
						
		$themezee_settings[] = array("name" => __('Footer Content', 'zeeFocusPro_language'),
						"desc" => __('Enter the content which is displayed in the footer here.', 'zeeFocusPro_language'),
						"id" => "themeZee_general_footer",
						"std" => "Place your Footer Content here",
						"type" => "html",
						"section" => "themeZee_general_layout");
						
		### CUSTOM CSS
		#######################################################################################					
		$themezee_settings[] = array("name" => __('Custom CSS', 'zeeFocusPro_language'),
						"desc" => __('Place your Custom CSS code here.', 'zeeFocusPro_language'),
						"id" => "themeZee_general_css",
						"std" => "",
						"type" => "textarea",
						"section" => "themeZee_general_css_section");
										
		return $themezee_settings;
	}

?>