<?php
	
	function themezee_sections_colors() {
		$themezee_sections = array();
		
		$themezee_sections[] = array('id' => 'themeZee_colors_schemes',
					'name' => __('Predefined Color Schemes', 'zeeMintyPro_language'));
					
		$themezee_sections[] = array('id' => 'themeZee_colors_custom',
					'name' => __('Custom Colors', 'zeeMintyPro_language'));
					
		$themezee_sections[] = array('id' => 'themeZee_colors_general',
					'name' => __('General Color Settings', 'zeeMintyPro_language'));

		$themezee_sections[] = array('id' => 'themeZee_colors_sidebar',
					'name' => __('Sidebar Color Settings', 'zeeMintyPro_language'));
					
		$themezee_sections[] = array('id' => 'themeZee_colors_frontpage',
					'name' => __('Frontpage Color Settings', 'zeeMintyPro_language'));
		
		return $themezee_sections;
	}
	
	function themezee_settings_colors() {
	
		$color_schemes = array(
			'#151515' => __('Black', 'zeeMintyPro_language'),
			'#0067dd' => __('Blue', 'zeeMintyPro_language'),
			'#725639' => __('Brown', 'zeeMintyPro_language'),
			'#777777' => __('Gray', 'zeeMintyPro_language'),
			'#e07000' => __('Orange', 'zeeMintyPro_language'),
			'#9215a5' => __('Purple', 'zeeMintyPro_language'),
			'#dd3333' => __('Red', 'zeeMintyPro_language'),
			'#008b9b' => __('Teal', 'zeeMintyPro_language'),
			'default' => __('Standard', 'zeeMintyPro_language'));
		
		$themezee_settings = array();
	
		### COLOR SETTINGS
		#######################################################################################
							
		$themezee_settings[] = array('name' => __('Set Color Scheme', 'zeeMintyPro_language'),
						'desc' => __('Please select your color scheme here.', 'zeeMintyPro_language'),
						'id' => 'themeZee_color_scheme',
						'std' => 'default',
						'type' => 'select',
						'choices' => $color_schemes,
						'section' => 'themeZee_colors_schemes'
						);
		
		$themezee_settings[] = array('name' => __('Active Custom Colors?', 'zeeMintyPro_language'),
						'desc' => __('Check this to activate the Custom Color Function.', 'zeeMintyPro_language'),
						'id' => 'themeZee_color_activate',
						'std' => 'false',
						'type' => 'checkbox',
						'section' => 'themeZee_colors_custom');	
						
		### GENERAL COLOR SETTINGS			
		#######################################################################################			
		$themezee_settings[] = array('name' => __('Link and Button Colors', 'zeeMintyPro_language'),
						'desc' => __('Select the color of links and buttons here.', 'zeeMintyPro_language'),
						'id' => 'themeZee_colors_link',
						'std' => '#00bc45',
						'type' => 'colorpicker',
						'section' => 'themeZee_colors_general');
						
		$themezee_settings[] = array('name' => __('Navigation Color', 'zeeMintyPro_language'),
						'desc' => __('Select the color of the navigation menus here.', 'zeeMintyPro_language'),
						'id' => 'themeZee_colors_navi',
						'std' => '#00bc45',
						'type' => 'colorpicker',
						'section' => 'themeZee_colors_general');
						
		$themezee_settings[] = array('name' => __('Post Title Color', 'zeeMintyPro_language'),
						'desc' => __('Select the color of post titles here.', 'zeeMintyPro_language'),
						'id' => 'themeZee_colors_post_title',
						'std' => '#00bc45',
						'type' => 'colorpicker',
						'section' => 'themeZee_colors_general');
		
		### SIDEBAR COLOR SETTINGS		
		#######################################################################################	
		$themezee_settings[] = array('name' => __('Widget Title Color', 'zeeMintyPro_language'),
						'desc' => __('Select the color of sidebar widget titles here.', 'zeeMintyPro_language'),
						'id' => 'themeZee_colors_sidebar_title',
						'std' => '#00bc45',
						'type' => 'colorpicker',
						'section' => 'themeZee_colors_sidebar');
						
		$themezee_settings[] = array('name' => __('Widget Link Color', 'zeeMintyPro_language'),
						'desc' => __('Select the color of sidebar widget links here.', 'zeeMintyPro_language'),
						'id' => 'themeZee_colors_sidebar_link',
						'std' => '#00bc45',
						'type' => 'colorpicker',
						'section' => 'themeZee_colors_sidebar');
						
		### FRONTPAGE COLOR SETTINGS		
		#######################################################################################	
		$themezee_settings[] = array('name' => __('Frontpage Widget Title Colors', 'zeeMintyPro_language'),
						'desc' => __('Select the color of the frontpage widget titles here.', 'zeeMintyPro_language'),
						'id' => 'themeZee_colors_frontpage_title',
						'std' => '#00bc45',
						'type' => 'colorpicker',
						'section' => 'themeZee_colors_frontpage');
						
		$themezee_settings[] = array('name' => __('Frontpage Widgets Link Color', 'zeeMintyPro_language'),
						'desc' => __('Select the link color of frontpage widgets here.', 'zeeMintyPro_language'),
						'id' => 'themeZee_colors_frontpage_link',
						'std' => '#00bc45',
						'type' => 'colorpicker',
						'section' => 'themeZee_colors_frontpage');
		
		return $themezee_settings;
	}

?>