<?php
	
	
	// Get available default Fonts
function themezee_get_web_fonts() { 
	
	// Default font array
	$themezee_fonts = array(
		'Arial' => 'Arial',
		'Arimo' => 'Arimo',
		'Alef' => 'Alef',
		'Carme' => 'Carme',
		'Droid Sans' => 'Droid Sans',
		'Francois One' => 'Francois One',
		'Josefin Slab' => 'Josefin Slab',
		'Lobster' => 'Lobster',
		'Luckiest Guy' => 'Luckiest Guy',
		'Jockey One' => 'Jockey One',
		'Maven Pro' => 'Maven Pro',
		'Modern Antiqua' => 'Modern Antiqua',
		'Nobile' => 'Nobile',
		'Oswald' => 'Oswald',
		'PT Sans' => 'PT Sans',
		'Permanent Marker' => 'Permanent Marker',
		'Roboto' => 'Roboto',
		'Share' => 'Share',
		'Tahoma' => 'Tahoma',
		'Ubuntu' => 'Ubuntu',
		'Verdana' => 'Verdana');
		
	// Add fonts installed by User
	$options = get_option('zeeminty_options');
	if ( isset($options['themeZee_fonts_installed']) and $options['themeZee_fonts_installed'] != '' ) :
		
		$fonts = explode(';', $options['themeZee_fonts_installed']);
		foreach ( $fonts as $value) {
			$themezee_fonts[trim($value)] = trim($value);
		}
		asort($themezee_fonts);
	endif;
	
	return $themezee_fonts; 
}


	function themezee_sections_fonts() {
		$themezee_sections = array();
		
		$themezee_sections[] = array('id' => 'themeZee_fonts_active',
					'name' => __('Activate Custom Fonts', 'zeeMintyPro_language'));
		
		$themezee_sections[] = array('id' => 'themeZee_fonts_family',
					'name' => __('Font Families', 'zeeMintyPro_language'));

		return $themezee_sections;
	}
	
	function themezee_settings_fonts() {
	
		// Array with all available Fonts to choose from
		$default_fonts = themezee_get_web_fonts();
	
		### FONTS SETTINGS
		#######################################################################################
		
		$themezee_settings[] = array('name' => __('Active Custom Fonts?', 'zeeMintyPro_language'),
						'desc' => __('Check this to activate Custom Fonts.', 'zeeMintyPro_language'),
						'id' => 'themeZee_fonts_activate',
						'std' => 'false',
						'type' => 'checkbox',
						'section' => 'themeZee_fonts_active');
						
		$themezee_settings[] = array('name' => __('Install more Fonts', 'zeeMintyPro_language'),
						'desc' => __('You want more fonts? You can install further fonts from the <a target="_blank" href="http://www.google.com/webfonts/">Google Font API</a> here. 
									Just insert a list of fonts separated by Semicolon, i.e  Arial; Galindo; Cantora One; ...', 'zeeMintyPro_language'),
						'id' => 'themeZee_fonts_installed',
						'std' => '',
						'type' => 'text',
						'section' => 'themeZee_fonts_active');
						
		$themezee_settings[] = array('name' => __('Text Font', 'zeeMintyPro_language'),
						'desc' => __('Select the font family of text here. (default = PT Sans)', 'zeeMintyPro_language'),
						'id' => 'themeZee_fonts_text',
						'std' => 'PT Sans',
						'type' => 'fontpicker',
						'choices' => $default_fonts,
						'section' => 'themeZee_fonts_family');
		
		$themezee_settings[] = array('name' => __('Navigation Font', 'zeeMintyPro_language'),
						'desc' => __('Select the navigation font here. (default = PT Sans)', 'zeeMintyPro_language'),
						'id' => 'themeZee_fonts_navi',
						'std' => '',
						'type' => 'fontpicker',
						'choices' => $default_fonts,
						'section' => 'themeZee_fonts_family');
						
		$themezee_settings[] = array('name' => __('Post/Page Title Fonts', 'zeeMintyPro_language'),
						'desc' => __('Select the title font here. (default = Arimo)', 'zeeMintyPro_language'),
						'id' => 'themeZee_fonts_title',
						'std' => 'Arimo',
						'type' => 'fontpicker',
						'choices' => $default_fonts,
						'section' => 'themeZee_fonts_family');
						
		$themezee_settings[] = array('name' => __('Widget Title Fonts', 'zeeMintyPro_language'),
						'desc' => __('Select the widget title font here. (default = PT Sans)', 'zeeMintyPro_language'),
						'id' => 'themeZee_fonts_widget',
						'std' => 'PT Sans',
						'type' => 'fontpicker',
						'choices' => $default_fonts,
						'section' => 'themeZee_fonts_family');
		
		return $themezee_settings;
	}
?>