<?php
/*
Template Name: Frontpage Template
*/
?>
<?php get_header('frontpage'); ?>

<?php $options = get_option('zeeminty_options'); // Get Theme Options from Database ?>

	<div id="wrap" class="container template-frontpage">
	
	<?php // Display Frontpage Intro text
	if(isset($options['themeZee_frontpage_intro_text']) and $options['themeZee_frontpage_intro_text'] != '' ) : ?>
		<div id="frontpage-intro" class="clearfix">
			<p class="frontpage-intro-text"><?php echo do_shortcode(wp_kses_post($options['themeZee_frontpage_intro_text'])); ?></p>
		</div>
	<?php endif; ?>
	
	
	<?php // Display Frontpage Widgets #1
	if(is_active_sidebar('frontpage-widgets-one')) : ?>
		<div id="frontpage-widgets-one" class="frontpage-widgets clearfix">
			<?php dynamic_sidebar('frontpage-widgets-one'); ?>
		</div>
	<?php endif; ?>
	
	<?php // Display Frontpage Widgets #2
	if(is_active_sidebar('frontpage-widgets-two')) : ?>
		<div id="frontpage-widgets-two" class="frontpage-widgets clearfix">
			<?php dynamic_sidebar('frontpage-widgets-two'); ?>
		</div>
	<?php endif; ?>
	
	<?php // Display Frontpage Widgets #3
	if(is_active_sidebar('frontpage-widgets-three')) : ?>
		<div id="frontpage-widgets-three" class="frontpage-widgets clearfix">
			<?php dynamic_sidebar('frontpage-widgets-three'); ?>
		</div>
	<?php endif; ?>
	
	
	<?php // Display Frontpage Entry
	if(isset($options['themeZee_frontpage_entry_text']) and $options['themeZee_frontpage_entry_text'] != '' ) : ?>
		<div id="frontpage-entry" class="clearfix">
			<h2 class="page-title"><span><?php echo esc_attr($options['themeZee_frontpage_entry_title']); ?></span></h2>
			<div class="entry"><?php echo apply_filters('the_content', wp_kses_post($options['themeZee_frontpage_entry_text'])); ?></div>
		</div>
	<?php endif; ?>
	
	
	<?php // Display latest blog posts on frontpage template
	if(isset($options['themeZee_frontpage_posts_active']) and $options['themeZee_frontpage_posts_active'] == 'true') :
		 
		themezee_display_frontpage_posts();
		 
	endif; ?>
	
	</div>
	
<?php get_footer(); ?>	