<?php
/***
 * Template Tags
 *
 * This file contains several template functions which are used to print out specific HTML markup
 * in the theme. You can override these template functions within your child theme.
 *
 */
	
	
// Display Custom Header
if ( ! function_exists( 'themezee_display_custom_header' ) ):
	
	function themezee_display_custom_header() {
		
		// Check if page is displayed and featured header image is used
		if( is_page() && has_post_thumbnail() ) :
		?>
			<div id="custom-header" class="header-image">
				<?php the_post_thumbnail('custom_header_image'); ?>
			</div>
<?php
		// Check if there is a custom header image
		elseif( get_header_image() ) :
		?>
			<div id="custom-header" class="header-image">
				<img src="<?php echo get_header_image(); ?>" />
			</div>
<?php 
		endif;

	}
	
endif;


// Display Postmeta Data
if ( ! function_exists( 'themezee_display_postmeta' ) ) :
	
	function themezee_display_postmeta() { ?>
		
		<span class="meta-date">
		<?php printf(__('Posted on <a href="%1$s" title="%2$s" rel="bookmark"><time datetime="%3$s">%4$s</time></a>', 'zeeMintyPro_language'), 
				esc_url( get_permalink() ),
				esc_attr( get_the_time() ),
				esc_attr( get_the_date( 'c' ) ),
				esc_html( get_the_date() )
			);
		?>
		</span>
		
		<span class="meta-author sep">
		<?php printf(__('by <a href="%1$s" title="%2$s" rel="author">%3$s</a>', 'zeeMintyPro_language'), 
				esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
				esc_attr( sprintf( __( 'View all posts by %s', 'zeeMintyPro_language' ), get_the_author() ) ),
				get_the_author()
			);
		?>
		</span>

	<?php if ( comments_open() ) : ?>
		<span class="meta-comments sep">
			<?php comments_popup_link( __('Leave a comment', 'zeeMintyPro_language'),__('One comment','zeeMintyPro_language'),__('% comments','zeeMintyPro_language') ); ?>
		</span>
	<?php endif; ?>
	<?php
		edit_post_link(__( 'Edit Post', 'zeeMintyPro_language' ));
	}
	
endif;


// Display Postinfo Data on Archive Pages
if ( ! function_exists( 'themezee_display_postinfo_index' ) ):
	
	function themezee_display_postinfo_index() { ?>
	
		<span class="meta-category">
			<?php printf(__('Posted in %1$s', 'zeeMintyPro_language'), get_the_category_list(', ')); ?>
		</span>
		
	<?php
	
	}
	
endif;


// Display Postinfo Data
if ( ! function_exists( 'themezee_display_postinfo_single' ) ):
	
	function themezee_display_postinfo_single() { ?>
		
		<span class="meta-category">
			<?php printf(__('Posted in %1$s', 'zeeMintyPro_language'), get_the_category_list(', ')); ?>
		</span>
		
	<?php
		$tag_list = get_the_tag_list('', ', ');
		if ( $tag_list ) : ?>
			<span class="meta-tags">
				<?php printf(__('tagged with %1$s', 'zeeMintyPro_language'), $tag_list); ?>
			</span>
	<?php 
		endif; 
		
	}
	
endif;

	
// Display Content Pagination
if ( ! function_exists( 'themezee_display_pagination' ) ):
	
	function themezee_display_pagination() { 
		
		global $wp_query;
		
		if ( $wp_query->max_num_pages > 1 ) :

			if(function_exists('wp_pagenavi')) : // if PageNavi is activated
				
				wp_pagenavi();
			
			else : // Otherwise, use traditional Navigation ?>
				
				<div class="post-pagination clearfix">
					<span class="post-pagination-alignleft"><?php next_posts_link(__('&laquo; Older Entries', 'zeeMintyPro_language')) ?></span>
					<span class="post-pagination-alignright"><?php previous_posts_link (__('Recent Entries &raquo;', 'zeeMintyPro_language')) ?></span>
				</div>
				
	<?php 	
			endif;
		endif;
		
	}
	
endif;


// Display Frontpage Slideshow
if ( ! function_exists( 'themezee_display_frontpage_slideshow' ) ):

	function themezee_display_frontpage_slideshow() { 
	
		$options = get_option('zeeminty_options'); // Get Theme Options from Database
		
		$query_arguments = array(
			'post_type' => 'frontpage_slider',
			'posts_per_page' => '-1',
			'order' => 'ASC',
			'orderby' => 'menu_order'
		);
		$zee_slider_query = new WP_Query($query_arguments);
		
		$slider = '';

		if ($zee_slider_query->have_posts()) : ?>
		
			<div id="frontpage-slider-wrap" class="clearfix">
				<div id="frontpage-slider" class="zeeflexslider">
					<ul class="zeeslides">
			
				<?php while ($zee_slider_query->have_posts()) : $zee_slider_query->the_post(); 
					
					$post_id = get_the_ID();
					
					$slider .= '<li id="slide-' . $post_id . '" class="zeeslide">';

					// Display Slide Entry
					if(isset($options['themeZee_frontpage_slider_content']) and $options['themeZee_frontpage_slider_content']  == 'true' ) :
						
						$slider .= '<div class="slide-entry-wrap">';
						$slider .= '<div class="slide-entry">';
						
						// Slide Title
						if ( get_post_meta( $post_id, "slide_link_url", true ) ) :
							$slider .= '<h2><a class="slide-link" href="' . get_post_meta( $post_id, "slide_link_url", true ) . '" title="' . the_title_attribute ( array( 'echo' => 0 ) ) . '" >' . get_the_title() . '</a></h2>';
						else :
							$slider .= '<h2 class="slide-title">' . get_the_title() . '</h2>';
						endif;
						
						// Slide Excerpt
						$slider .= '<div class="slide-excerpt">' . wp_trim_words(get_the_excerpt(), 10);
						
						if ( get_post_meta( $post_id, "slide_link_url", true ) ) :
							
							$slider .= '<div class="read-more"><a class="more-link" href="' . get_post_meta( $post_id, "slide_link_url", true ) . '" title="' .  the_title_attribute ( array( 'echo' => 0 ) ) . '" >';
							if ( get_post_meta( get_the_ID(), "slide_link_name", true ) ) : 
								$slider .= esc_attr(get_post_meta( get_the_ID(), "slide_link_name", true ));
							else : 
								$slider .= __('Read more &raquo;', 'zeeMintyPro_language');
							endif;
							$slider .= '</a></div>';
							
						endif;
						
						$slider .= '</div>';
						
						$slider .= '</div>';
						$slider .= '</div>';
						
					endif;
					
					// Display Slide Image
					if ( has_post_thumbnail() ) :

						$slider .= get_the_post_thumbnail( $post_id, 'frontpage_image', array( 'class' => 'slide-image' ) );
						
					endif;

					
					$slider .= '</li>';
				?>
				
				<?php endwhile; ?>
			
			<?php echo $slider; ?>
			
					</ul>
				</div>
			</div>
		
		<?php endif;
	
		wp_reset_postdata();
	
	}
	
endif;


// Display Frontpage Blog Posts
if ( ! function_exists( 'themezee_display_frontpage_posts' ) ):
	
	function themezee_display_frontpage_posts() { 
	
		// Get Theme Options from Database
		$options = get_option('zeeminty_options'); 
		
		$query_arguments = array(
			'post_type' => 'post',
			'post_status' => 'publish',
			'showposts' => 3,
			'caller_get_posts' => 1,
			'orderby' => 'date'
			);
		$zee_frontpage_posts_query = new WP_Query($query_arguments);
	?>
		
		<div id="frontpage-posts" class="clearfix">
			
			<div class="frontpage-posts-head">
				<h2 class="frontpage-posts-title"><?php echo esc_attr($options['themeZee_frontpage_posts_title']); ?></h2>
			</div>
			<?php if ($zee_frontpage_posts_query->have_posts()) : while ($zee_frontpage_posts_query->have_posts()) : $zee_frontpage_posts_query->the_post(); ?>
			
				<div class="frontpage-post">
					
					<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

						<h3 class="post-title"><a href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a></h3>
						
					<?php if(isset($options['themeZee_frontpage_post_postmeta']) and $options['themeZee_frontpage_post_postmeta'] == 'true') : ?>
						<div class="postmeta">
							<span class="meta-date"><a href="<?php the_permalink() ?>"><?php the_time(get_option('date_format')); ?></a></span>
						</div>
					<?php endif; ?>
					
						<div class="entry clearfix">
							
							<?php if(isset($options['themeZee_frontpage_post_thumbnails']) and $options['themeZee_frontpage_post_thumbnails'] == 'true') : ?>
								<a href="<?php the_permalink() ?>" rel="bookmark"><?php the_post_thumbnail('featured_image', array('class' => 'alignleft')); ?></a>
							<?php endif; ?>
							
							<?php if(isset($options['themeZee_frontpage_post_excerpt']) and $options['themeZee_frontpage_post_excerpt'] == 'true') :
								the_excerpt(); ?>
								<a href="<?php the_permalink() ?>" class="more-link"><?php _e('Read more &raquo;', 'zeeMintyPro_language'); ?></a>
							<?php endif; ?>
							
						</div>
					
					</div>
					
				</div>
			<?php endwhile; ?>
		
		<?php endif; ?>
		
		</div>
		
		<?php wp_reset_postdata();
	}
	
endif;


?>