<?php
	
	function themezee_sections_colors() {
		$themezee_sections = array();
		
		$themezee_sections[] = array("id" => "themeZee_colors_schemes",
					"name" => __('Predefined Color Schemes', 'zeeFocusPro_language'));
					
		$themezee_sections[] = array("id" => "themeZee_colors_custom",
					"name" => __('Custom Colors', 'zeeFocusPro_language'));
					
		$themezee_sections[] = array("id" => "themeZee_colors_settings",
					"name" => __('General Color Settings', 'zeeFocusPro_language'));
					
		$themezee_sections[] = array("id" => "themeZee_colors_content",
					"name" => __('Content Color Settings', 'zeeFocusPro_language'));
					
		$themezee_sections[] = array("id" => "themeZee_colors_widgets",
					"name" => __('Widget Color Settings', 'zeeFocusPro_language'));
		
		return $themezee_sections;
	}
	
	function themezee_settings_colors() {
	
		$color_schemes = array(
			'#151515' => __('Black', 'zeeFocusPro_language'),
			'#1562a5' => __('Blue', 'zeeFocusPro_language'),
			'#725639' => __('Brown', 'zeeFocusPro_language'),
			'#2d912e' => __('Green', 'zeeFocusPro_language'),
			'#9215a5' => __('Purple', 'zeeFocusPro_language'),
			'#dd3333' => __('Red', 'zeeFocusPro_language'),
			'#009b91' =>  __('Teal', 'zeeFocusPro_language'),
			'default' => __('Standard', 'zeeFocusPro_language'));
		
		$themezee_settings = array();
	
		### COLOR SETTINGS
		#######################################################################################
							
		$themezee_settings[] = array("name" => __('Set Color Scheme', 'zeeFocusPro_language'),
						"desc" => __('Please select your color scheme here.', 'zeeFocusPro_language'),
						"id" => "themeZee_color_scheme",
						"std" => "default",
						"type" => "select",
						'choices' => $color_schemes,
						"section" => "themeZee_colors_schemes"
						);
		
		$themezee_settings[] = array("name" => __('Active Custom Colors?', 'zeeFocusPro_language'),
						"desc" => __('Check this to activate the Custom Color Function.', 'zeeFocusPro_language'),
						"id" => "themeZee_color_activate",
						"std" => "false",
						"type" => "checkbox",
						"section" => "themeZee_colors_custom");	
						
		### GENERAL COLOR SETTINGS			
		#######################################################################################			
		$themezee_settings[] = array("name" => __('Link Color', 'zeeFocusPro_language'),
						"desc" => __("Select the color of links here.", 'zeeFocusPro_language'),
						"id" => "themeZee_colors_link",
						"std" => "#ff6128",
						"type" => "colorpicker",
						"section" => "themeZee_colors_settings");
						
		$themezee_settings[] = array("name" => __('Page Header and Footer', 'zeeFocusPro_language'),
						"desc" => __("Select the background color of the page header and footer area here.", 'zeeFocusPro_language'),
						"id" => "themeZee_colors_page_header",
						"std" => "#ff6128",
						"type" => "colorpicker",
						"section" => "themeZee_colors_settings");
						
		$themezee_settings[] = array("name" => __('Navigation Color', 'zeeFocusPro_language'),
						"desc" => __("Select the background color of navigation menu and footer line here.", 'zeeFocusPro_language'),
						"id" => "themeZee_colors_navi",
						"std" => "#ff6128",
						"type" => "colorpicker",
						"section" => "themeZee_colors_settings");
		
		### CONTENT COLOR SETTINGS			
		#######################################################################################			
		$themezee_settings[] = array("name" => __('Post Title Color', 'zeeFocusPro_language'),
						"desc" => __("Select the color of post titles here.", 'zeeFocusPro_language'),
						"id" => "themeZee_colors_post_title",
						"std" => "#ff6128",
						"type" => "colorpicker",
						"section" => "themeZee_colors_content");
						
			$themezee_settings[] = array("name" => __('Button Colors', 'zeeFocusPro_language'),
						"desc" => __("Select the color of the Read More and Comment button here.", 'zeeFocusPro_language'),
						"id" => "themeZee_colors_buttons",
						"std" => "#ff6128",
						"type" => "colorpicker",
						"section" => "themeZee_colors_content");
		
						
		$themezee_settings[] = array("name" => __('Frontpage Title Colors', 'zeeFocusPro_language'),
						"desc" => __("Select the colors of post and widget titles on the frontpage template here.", 'zeeFocusPro_language'),
						"id" => "themeZee_colors_frontpage",
						"std" => "#ff6128",
						"type" => "colorpicker",
						"section" => "themeZee_colors_content");
		
		### SIDEBAR COLOR SETTINGS		
		#######################################################################################	
		$themezee_settings[] = array("name" => __('Widget Title Color', 'zeeFocusPro_language'),
						"desc" => __("Select the color of widget titles here.", 'zeeFocusPro_language'),
						"id" => "themeZee_colors_widget_title",
						"std" => "#333333",
						"type" => "colorpicker",
						"section" => "themeZee_colors_widgets");
						
		$themezee_settings[] = array("name" => __('Widget Link Color', 'zeeFocusPro_language'),
						"desc" => __("Select the color of widget links here.", 'zeeFocusPro_language'),
						"id" => "themeZee_colors_widget_link",
						"std" => "#ff6128",
						"type" => "colorpicker",
						"section" => "themeZee_colors_widgets");
		
		return $themezee_settings;
	}

?>