<?php
	
	
	// Get available default Fonts
function themezee_get_web_fonts() { 
	
	// Default font array
	$themezee_fonts = array(
		'Arial' => 'Arial',
		'Arimo' => 'Arimo',
		'Cabin' => 'Cabin',
		'Carme' => 'Carme',
		'Droid Sans' => 'Droid Sans',
		'Francois One' => 'Francois One',
		'Josefin Slab' => 'Josefin Slab',
		'Lobster' => 'Lobster',
		'Luckiest Guy' => 'Luckiest Guy',
		'Jockey One' => 'Jockey One',
		'Maven Pro' => 'Maven Pro',
		'Modern Antiqua' => 'Modern Antiqua',
		'Muli' => 'Muli',
		'Nobile' => 'Nobile',
		'Oswald' => 'Oswald',
		'Permanent Marker' => 'Permanent Marker',
		'Share' => 'Share',
		'Tahoma' => 'Tahoma',
		'Ubuntu' => 'Ubuntu',
		'Verdana' => 'Verdana');
		
	// Add fonts installed by User
	$options = get_option('zeefocus_options');
	if ( isset($options['themeZee_fonts_installed']) and $options['themeZee_fonts_installed'] != '' ) :
		
		$fonts = explode(";", $options['themeZee_fonts_installed']);
		foreach ( $fonts as $value) {
			$themezee_fonts[trim($value)] = trim($value);
		}
		asort($themezee_fonts);
	endif;
	
	return $themezee_fonts; 
}


	function themezee_sections_fonts() {
		$themezee_sections = array();
		
		$themezee_sections[] = array("id" => "themeZee_fonts_active",
					"name" => __('Activate Custom Fonts', 'zeeFocusPro_language'));
		
		$themezee_sections[] = array("id" => "themeZee_fonts_family",
					"name" => __('Font Families', 'zeeFocusPro_language'));

		return $themezee_sections;
	}
	
	function themezee_settings_fonts() {
	
		// Array with all available Fonts to choose from
		$default_fonts = themezee_get_web_fonts();
	
		### FONTS SETTINGS
		#######################################################################################
		
		$themezee_settings[] = array("name" => __('Active Custom Fonts?', 'zeeFocusPro_language'),
						"desc" => __('Check this to activate Custom Fonts.', 'zeeFocusPro_language'),
						"id" => "themeZee_fonts_activate",
						"std" => "false",
						"type" => "checkbox",
						"section" => "themeZee_fonts_active");
						
		$themezee_settings[] = array("name" => __('Install more Fonts', 'zeeFocusPro_language'),
						"desc" => __('You want more fonts? You can install further fonts from the <a target="_blank" href="http://www.google.com/webfonts/">Google Font API</a> here. 
									Just insert a list of fonts separated by Semicolon, i.e  Arial; Galindo; Cantora One; ...', 'zeeFocusPro_language'),
						"id" => "themeZee_fonts_installed",
						"std" => "",
						"type" => "text",
						"section" => "themeZee_fonts_active");
						
		$themezee_settings[] = array("name" => __('Text Font', 'zeeFocusPro_language'),
						"desc" => __("Select the font family of text here. (default = Muli)", 'zeeFocusPro_language'),
						"id" => "themeZee_fonts_text",
						"std" => "Muli",
						"type" => "fontpicker",
						'choices' => $default_fonts,
						"section" => "themeZee_fonts_family");
		
		$themezee_settings[] = array("name" => __('Navigation Font', 'zeeFocusPro_language'),
						"desc" => __("Select the navigation font here. (default = Muli)", 'zeeFocusPro_language'),
						"id" => "themeZee_fonts_navi",
						"std" => "Muli",
						"type" => "fontpicker",
						'choices' => $default_fonts,
						"section" => "themeZee_fonts_family");
						
		$themezee_settings[] = array("name" => __('Header Title Font', 'zeeFocusPro_language'),
						"desc" => __("Select the navigation font here. (default = Muli)", 'zeeFocusPro_language'),
						"id" => "themeZee_fonts_header",
						"std" => "Muli",
						"type" => "fontpicker",
						'choices' => $default_fonts,
						"section" => "themeZee_fonts_family");
						
		$themezee_settings[] = array("name" => __('Post Title Font', 'zeeFocusPro_language'),
						"desc" => __("Select the font of post titles here. (default = Cabin)", 'zeeFocusPro_language'),
						"id" => "themeZee_fonts_title",
						"std" => "Cabin",
						"type" => "fontpicker",
						'choices' => $default_fonts,
						"section" => "themeZee_fonts_family");
						
		$themezee_settings[] = array("name" => __('Widget Title Font', 'zeeFocusPro_language'),
						"desc" => __("Select the widget title font here. (default = Cabin)", 'zeeFocusPro_language'),
						"id" => "themeZee_fonts_widget",
						"std" => "Cabin",
						"type" => "fontpicker",
						'choices' => $default_fonts,
						"section" => "themeZee_fonts_family");
		
		return $themezee_settings;
	}
?>