<?php
/***
 * Template Tags
 *
 * This file contains several template functions which are used to print out specific HTML markup
 * in the theme. You can override these template functions within your child theme.
 *
 */

 
// Display Custom Header
if ( ! function_exists( 'themezee_display_custom_header' ) ):
	
	function themezee_display_custom_header() {
		
		// Check if page is displayed and featured header image is used
		if( is_page() && has_post_thumbnail() ) :
		?>
			<div id="custom-header" class="container">
				<?php the_post_thumbnail('custom_header_image'); ?>
			</div>
<?php
		// Check if there is a custom header image
		elseif( get_header_image() ) :
		?>
			<div id="custom-header" class="container">
				<img src="<?php echo get_header_image(); ?>" />
			</div>
<?php 
		endif;

	}
	
endif;


// Display default Page Header Title
if ( ! function_exists( 'themezee_display_default_page_header' ) ):
	
	function themezee_display_default_page_header() {
		
		$options = get_option('zeefocus_options');
			
		if( isset($options['themeZee_general_page_header']) and $options['themeZee_general_page_header'] <> "" ) : ?>
			
			<h2 class="page-title"><?php echo esc_attr($options['themeZee_general_page_header']); ?></h2>
			
	<?php else: ?>
		
			<h2 class="page-title"><?php echo _e('Blog', 'zeeFocusPro_language'); ?></h2>
		
	<?php endif;

	}
	
endif;


// Display Postmeta Data
if ( ! function_exists( 'themezee_display_postmeta' ) ):
	
	function themezee_display_postmeta() { ?>
		
		<span class="meta-category">
			<?php printf(__('Posted in %1$s', 'zeeFocusPro_language'), get_the_category_list(', ')); ?>
		</span>
		
		<span class="meta-author sep">
		<?php printf(__('by <a href="%1$s" title="%2$s" rel="author">%3$s</a>', 'zeeFocusPro_language'), 
				esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
				esc_attr( sprintf( __( 'View all posts by %s', 'zeeFocusPro_language' ), get_the_author() ) ),
				get_the_author()
			);
		?>
		</span>

	<?php if ( comments_open() ) : ?>
		<span class="meta-comments sep">
			<?php comments_popup_link( __('Leave a comment', 'zeeFocusPro_language'),__('One comment','zeeFocusPro_language'),__('% comments','zeeFocusPro_language') ); ?>
		</span>
	<?php endif; ?>
	<?php
		edit_post_link(__( 'Edit Post', 'zeeFocusPro_language' ));
	}
	
endif;


// Display Post Tags
if ( ! function_exists( 'themezee_display_post_tags' ) ):
	
	function themezee_display_post_tags() {
		
		$tag_list = get_the_tag_list(__( 'Tagged with: ', 'zeeFocusPro_language' ), '');
		if ( $tag_list ) : ?>
			<div class="meta-tags">
				<?php echo $tag_list; ?>
			</div>
	<?php 
		endif;
		
	}
	
endif;

	
// Display Content Pagination
if ( ! function_exists( 'themezee_display_pagination' ) ):
	
	function themezee_display_pagination() { 
		
		global $wp_query;
		
		if ( $wp_query->max_num_pages > 1 ) :

			if(function_exists('wp_pagenavi')) : // if PageNavi is activated
				
				wp_pagenavi();
			
			else : // Otherwise, use traditional Navigation ?>
				
				<div class="post-pagination clearfix">
					<span class="post-pagination-alignleft"><?php next_posts_link(__('&laquo; Older Entries', 'zeeFocusPro_language')) ?></span>
					<span class="post-pagination-alignright"><?php previous_posts_link (__('Recent Entries &raquo;', 'zeeFocusPro_language')) ?></span>
				</div>
				
	<?php 	
			endif;
		endif;
		
	}
	
endif;


// Display Frontpage Slideshow
if ( ! function_exists( 'themezee_display_frontpage_slideshow' ) ):

	function themezee_display_frontpage_slideshow() { 
	
		$options = get_option('zeefocus_options'); // Get Theme Options from Database
		
		$query_arguments = array(
			'post_type' => 'frontpage_slider',
			'posts_per_page' => '-1',
			'order' => 'ASC',
			'orderby' => 'menu_order'
		);
		$zee_slider_query = new WP_Query($query_arguments);
		
		$slider = '';
		
		if ($zee_slider_query->have_posts()) : ?>
		
			<div id="frontpage-slider-wrap" class="container clearfix">
				<div id="frontpage-slider" class="zeeflexslider">
					<ul class="zeeslides">
			
				<?php while ($zee_slider_query->have_posts()) : $zee_slider_query->the_post(); 
					
					$post_id = get_the_ID();
					
					$slider .= '<li id="slide-' . $post_id . '" class="zeeslide">';

					if ( has_post_thumbnail() ) :

						if ( get_post_meta( $post_id, "slide_link_url", true ) ) :
							$slider .= '<a href="' . get_post_meta( $post_id, "slide_link_url", true ) . '" title="' .  the_title_attribute ( array( 'echo' => 0 ) ) . '" >';
						endif;
						
						$slider .= get_the_post_thumbnail( $post_id, 'frontpage_image', array( 'class' => 'slide-image' ) );

						if ( get_post_meta( $post_id, "slide_link_url", true ) ) :
							$slider .= '</a>';
						endif;
						
					endif;
					
					
					if(isset($options['themeZee_frontpage_slider_title']) and $options['themeZee_frontpage_slider_title']  == 'true' ) :
						
						if ( get_post_meta( $post_id, "slide_link_url", true ) ) :
							$slider .= '<h2><a class="slide-link" href="' . get_post_meta( $post_id, "slide_link_url", true ) . '" title="' . the_title_attribute ( array( 'echo' => 0 ) ) . '" >' . get_the_title() . '</a></h2>';
						else :
							$slider .= '<h2 class="slide-title">' . get_the_title() . '</h2>';
						endif;
						
					endif;
					
					$slider .= '</li>';
				?>
				
				<?php endwhile; ?>
			
			<?php echo $slider; ?>
			
					</ul>
				</div>
			</div>
		<?php endif; ?>
	
	<?php wp_reset_postdata();
	
	}
	
endif;


// Display Frontpage Blog Posts
if ( ! function_exists( 'themezee_display_frontpage_posts' ) ):
	
	function themezee_display_frontpage_posts() { 
	
		// Get Theme Options from Database
		$options = get_option('zeefocus_options'); 
		
		$slider_limit = intval($options['themeZee_frontpage_posts_limit']);
		
		$query_arguments = array(
			'post_type' => 'post',
			'post_status' => 'publish',
			'showposts' => $slider_limit,
			'caller_get_posts' => 1,
			'orderby' => 'date'
			);
		$zee_frontpage_posts_query = new WP_Query($query_arguments);
		$row = 2;
	?>
		
		<div id="frontpage-posts" class="clearfix">
			
			<div id="frontpage-posts-head" class="clearfix">
				<h2 class="frontpage-posts-title"><?php echo esc_attr($options['themeZee_frontpage_posts_title']); ?></h2>
				<div class="frontpage-posts-slidenav"></div>
			</div>
			
			<?php if ($zee_frontpage_posts_query->have_posts()) : ?>
			
			<div id="carousel-slider" class="zeecarousel-slider">
				<ul class="zeecarousel-slides">
			
				<?php while ($zee_frontpage_posts_query->have_posts()) : $zee_frontpage_posts_query->the_post(); ?>
			
				<?php if ($row % 2 == 0) : ?>
					<li id="slide-<?php the_ID(); ?>" class="zeecarousel-slide">
				<?php endif; ?>
					
						<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						
						<?php if(isset($options['themeZee_frontpage_post_thumbnails']) and $options['themeZee_frontpage_post_thumbnails'] == 'true') : ?>
							<a href="<?php the_permalink() ?>" rel="bookmark"><?php the_post_thumbnail('featured_image'); ?></a>
						<?php endif; ?>
							
							<div class="post-title-wrap clearfix">
								<span class="meta-date">
									<?php printf(__('<a href="%1$s" title="%2$s" rel="bookmark"><time datetime="%3$s">%4$s</time></a>', 'zeeFocusPro_language'), 
											esc_url( get_permalink() ),
											esc_attr( get_the_time() ),
											esc_attr( get_the_date( 'c' ) ),
											esc_html( get_the_date() )
										);
									?>
								</span>
								<h3 class="post-title"><a href="<?php esc_url(the_permalink()) ?>" rel="bookmark"><?php the_title(); ?></a></h3>
							</div>
						
						<?php if(isset($options['themeZee_frontpage_post_excerpt']) and $options['themeZee_frontpage_post_excerpt'] == 'true') : ?>
							<div class="entry">
								<?php the_excerpt(); ?>
								<a href="<?php the_permalink() ?>" class="read-more"><?php _e('Read more', 'zeeFocusPro_language'); ?></a>
							</div>
						<?php endif; ?>
						
						<?php if(isset($options['themeZee_frontpage_post_postmeta']) and $options['themeZee_frontpage_post_postmeta'] == 'true') : ?>
							<div class="postmeta">
								<span class="meta-date"><a href="<?php the_permalink() ?>"><?php the_time(get_option('date_format')); ?></a></span>
								<span class="meta-comments sep"><?php comments_popup_link( __('Leave a comment', 'zeeFocusPro_language'),__('One comment','zeeFocusPro_language'),__('% comments','zeeFocusPro_language') ); ?></span>
							</div>
						<?php endif; ?>
						
						</div>
						
				<?php if ($row % 2 == 1) : ?>
					</li>
				<?php endif; $row++ ?>	

			<?php endwhile; ?>
			
				</ul>
			</div>
		
		<?php endif; ?>
		
		</div>
		
		<?php wp_reset_postdata();
	}
	
endif;


?>