<?php
	
	function themezee_sections_frontpage() {
		$themezee_sections = array();
		
		$themezee_sections[] = array('id' => 'themeZee_frontpage_template',
					'name' => __('Activate Frontpage Template', 'zeeMintyPro_language'));
					
		$themezee_sections[] = array('id' => 'themeZee_frontpage_image',
					'name' => __('Frontpage Image', 'zeeMintyPro_language'));
					
		$themezee_sections[] = array('id' => 'themeZee_frontpage_slider',
					'name' => __('Frontpage Slider', 'zeeMintyPro_language'));
					
		$themezee_sections[] = array('id' => 'themeZee_frontpage_intro',
					'name' => __('Frontpage Intro', 'zeeMintyPro_language'));
					
		$themezee_sections[] = array('id' => 'themeZee_frontpage_widgets',
					'name' => __('Frontpage Widgets', 'zeeMintyPro_language'));
					
		$themezee_sections[] = array('id' => 'themeZee_frontpage_entry',
					'name' => __('Frontpage Entry', 'zeeMintyPro_language'));
					
		$themezee_sections[] = array('id' => 'themeZee_frontpage_posts',
					'name' => __('Frontpage Blog Posts', 'zeeMintyPro_language'));

		return $themezee_sections;
	}
	
	function themezee_settings_frontpage() {
	
		
		### FRONTPAGE Template
		#######################################################################################
		$themezee_settings[] = array('name' => __('Turn on Frontpage Template?', 'zeeMintyPro_language'),
						'desc' => __('Check this to automatically display the frontpage template on HOME page. You can also manually create a page and select the "Frontpage Template" page template instead of using this option.', 'zeeMintyPro_language'),
						'id' => 'themeZee_frontpage_activate',
						'std' => 'false',
						'type' => 'checkbox',
						'section' => 'themeZee_frontpage_template');
		
		### FRONTPAGE Image
		#######################################################################################
		$themezee_settings[] = array('name' => __('Frontpage Image Source', 'zeeMintyPro_language'),
						'desc' => __('Choose which image(s) the frontpage template should display.', 'zeeMintyPro_language'),
						'id' => 'themeZee_frontpage_image_source',
						'std' => 'upload',
						'type' => 'radio',
						'choices' => array(
									'header' => __('Custom Header Image (from Appearance > Header)', 'zeeMintyPro_language'),
									'upload' => __('Individual Image uploaded below', 'zeeMintyPro_language'),
									'slideshow' => __('Image Slideshow using Custom Post Type Slideshow', 'zeeMintyPro_language')),
						'section' => 'themeZee_frontpage_image'
						);
		
		$themezee_settings[] = array('name' => __('Frontpage Image', 'zeeMintyPro_language'),
						'desc' => __('Upload an individual frontpage image here. You have to select "Individual Image" above to display it. Image should be 1920x550 pixels.', 'zeeMintyPro_language'),
						'id' => 'themeZee_frontpage_image_upload',
						'std' => get_template_directory_uri() . '/images/default-slider-image.jpg',
						'type' => 'image',
						'section' => 'themeZee_frontpage_image');
						
		### FRONTPAGE Slider
		#######################################################################################
		$themezee_settings[] = array('name' => __('Slider Animation', 'zeeMintyPro_language'),
						'desc' => '',
						'id' => 'themeZee_frontpage_slider_animation',
						'std' => '0',
						'type' => 'radio',
						'choices' => array(
									'slide' => __('Horizontal Slider', 'zeeMintyPro_language'),
									'fade' => __('Fade Slider', 'zeeMintyPro_language')),
						'section' => 'themeZee_frontpage_slider'
						);
						
		$themezee_settings[] = array('name' => __('Show Slider Content?', 'zeeMintyPro_language'),
						'desc' => __('Check this to display the slider title and slider excerpt on the slides.', 'zeeMintyPro_language'),
						'id' => 'themeZee_frontpage_slider_content',
						'std' => 'false',
						'type' => 'checkbox',
						'section' => 'themeZee_frontpage_slider');
						
						
		$themezee_settings[] = array('name' => __('Slider Speed', 'zeeMintyPro_language'),
						'desc' => __('Enter the speed of the slideshow cycling (timeout between slides), in milliseconds.', 'zeeMintyPro_language'),
						'id' => 'themeZee_frontpage_slider_speed',
						'std' => '7000',
						'type' => 'text',
						'section' => 'themeZee_frontpage_slider');		
		
								
		### FRONTPAGE INTRO
		#######################################################################################							
		$themezee_settings[] = array('name' => __('Frontpage Intro Text', 'zeeMintyPro_language'),
						'desc' => __('Enter here the Text of the Frontpage Intro.', 'zeeMintyPro_language'),
						'id' => 'themeZee_frontpage_intro_text',
						'std' => '',
						'type' => 'editor',
						'section' => 'themeZee_frontpage_intro');

		### FRONTPAGE WIDGETS
		#######################################################################################		
		$themezee_settings[] = array('name' => __('About Frontpage Widgets', 'zeeMintyPro_language'),
						'desc' => __('Please note: You can configure your widgets to be displayed on the frontpage template on <b>Appearance > Widgets</b>.', 'zeeMintyPro_language'),
						'id' => 'themeZee_frontpage_widgets_info',
						'type' => 'info',
						'std' => '',
						'section' => 'themeZee_frontpage_widgets');
						
						
		### FRONTPAGE ENTRY
		#######################################################################################			
		$themezee_settings[] = array('name' => __('Frontpage Entry Title', 'zeeMintyPro_language'),
						'desc' => __('Enter here the title of your normal page content displayed on the frontpage template.', 'zeeMintyPro_language'),
						'id' => 'themeZee_frontpage_entry_title',
						'std' => '',
						'type' => 'text',
						'section' => 'themeZee_frontpage_entry');
						
		$themezee_settings[] = array('name' => __('Frontpage Entry', 'zeeMintyPro_language'),
						'desc' => __('Enter here normal page content displayed on the frontpage template (one column).', 'zeeMintyPro_language'),
						'id' => 'themeZee_frontpage_entry_text',
						'std' => '',
						'type' => 'editor',
						'section' => 'themeZee_frontpage_entry');
		
		### FRONTPAGE POSTS
		#######################################################################################		
		$themezee_settings[] = array('name' => __('Show Frontpage Blog Posts?', 'zeeMintyPro_language'),
						'desc' => __('Check this to show the latest blog post on the frontpage template', 'zeeMintyPro_language'),
						'id' => 'themeZee_frontpage_posts_active',
						'std' => 'false',
						'type' => 'checkbox',
						'section' => 'themeZee_frontpage_posts');
						
		$themezee_settings[] = array('name' => __('Header Title of the latest blog posts', 'zeeMintyPro_language'),
						'desc' => __('Enter here the Title which is displayed above the latest blog posts.', 'zeeMintyPro_language'),
						'id' => 'themeZee_frontpage_posts_title',
						'std' => 'Latest Blog Posts',
						'type' => 'text',
						'section' => 'themeZee_frontpage_posts');
						
		$themezee_settings[] = array('name' => __('Blog Posts Content', 'zeeMintyPro_language'),
						'desc' => __('Select which content should be displayed at the frontpage blog posts.', 'zeeMintyPro_language'),
						'id' => 'themeZee_frontpage_post',
						'std' => 'true',
						'type' => 'multicheckbox',
						'choices' => array(
									'thumbnails' => __('Display Thumbnails', 'zeeMintyPro_language'),
									'postmeta' => __('Display Postmeta', 'zeeMintyPro_language'),
									'excerpt' => __('Display Excerpt', 'zeeMintyPro_language')),
						'section' => 'themeZee_frontpage_posts'
						);
		
		return $themezee_settings;
	}

?>