<?php if (!defined('WPO_VERSION'))  die('No direct access allowed'); ?>
<div class="wpo_section wpo_group<?php echo (!$wpo_minify_options['enable_css']) ? ' wpo-feature-is-disabled' : ''; ?>">
	<div id="wpo_settings_warnings"></div>

	<div class="wpo-fieldgroup wpo-show">
		<div class="wpo-fieldgroup__subgroup wpo_min_enable_minify">
			<div class="switch-container">
				<label class="switch">
					<input
						name="enable_css"
						id="wpo_min_enable_minify_css"
						class="wpo-save-setting"
						type="checkbox"
						value="true"
						<?php checked($wpo_minify_options['enable_css']);?>
					>
					<span class="slider round"></span>
				</label>
				<label for="wpo_min_enable_minify_css">
					<?php _e('Enable Minify for CSS files', 'wp-optimize'); ?>
					<b tabindex="0" data-tooltip="<?php esc_attr_e('The stylesheets will be combined and minified to lower the number and size of requests.', 'wp-optimize');?>"><span class="dashicons dashicons-editor-help"></span> </b>
				</label>
			</div>
		</div>
	</div>

	<form>
		<h3><?php _e('CSS options', 'wp-optimize'); ?></h3>
		<div class="wpo-fieldgroup">
			<fieldset>
				<label for="enable_css_minification">
					<input
						name="enable_css_minification"
						type="checkbox"
						id="enable_css_minification"
						value="1"
						<?php echo checked($wpo_minify_options['enable_css_minification']); ?>
					>
					<?php _e('Enable minification of CSS files', 'wp-optimize'); ?>
					<b tabindex="0" data-tooltip="<?php esc_attr_e('If disabled, the CSS files will be merged but not minified', 'wp-optimize');?>"><span class="dashicons dashicons-editor-help"></span> </b>
				</label>
				<label for="inline_css">
					<input
						name="inline_css"
						type="checkbox"
						id="inline_css"
						value="1"
						<?php echo checked($wpo_minify_options['inline_css']); ?>
					>
					<?php _e('Inline CSS', 'wp-optimize'); ?> - <?php _e('Recommended if the CSS files are small enough.', 'wp-optimize'); ?>
					<b tabindex="0" data-tooltip="<?php _e('When enabled, the CSS files generated by WP-Optmize will be inlined.', 'wp-optimize');?>"><span class="dashicons dashicons-editor-help"></span> </b>
				</label>
				<label for="skip_cssorder">
					<input
						name="skip_cssorder"
						type="checkbox"
						id="skip_cssorder"
						value="1"
						<?php echo checked($wpo_minify_options['skip_cssorder']); ?>
					>
					<?php _e('Preserve the order of CSS files', 'wp-optimize'); ?>
					<b tabindex="0" data-tooltip="<?php _e('Enabling this improves CSS compatibility when merging, but might result in more files.', 'wp-optimize');?>"><span class="dashicons dashicons-editor-help"></span> </b>
				</label>
				<label for="remove_print_mediatypes">
					<input
						name="remove_print_mediatypes"
						type="checkbox"
						id="remove_print_mediatypes"
						value="1"
						<?php echo checked($wpo_minify_options['remove_print_mediatypes']); ?>
					>
					<?php _e('Strip the "print" related stylesheets', 'wp-optimize'); ?>
					<b tabindex="0" data-tooltip='<?php _e('When selected, any CSS files with the media type "print" will be removed.', 'wp-optimize');?> <?php _e('Enable if your site does not need specific print styles.', 'wp-optimize');?>'><span class="dashicons dashicons-editor-help"></span> </b>
				</label>
				<?php if (WP_OPTIMIZE_SHOW_MINIFY_ADVANCED) : ?>
					<label for="remove_css">
						<input
							name="remove_css"
							type="checkbox"
							id="remove_css"
							value="1"
							<?php echo checked($wpo_minify_options['remove_css']); ?>
						>
						<?php _e('Dequeue all CSS files', 'wp-optimize'); ?>
						<b tabindex="0" data-tooltip="<?php _e('This is useful if you want to test your critical path CSS', 'wp-optimize');?>"><span class="dashicons dashicons-editor-help"></span> </b>
					</label>
				<?php endif; ?>
			</fieldset>
		</div>

		<h3><?php _e('Exclude the following CSS files from processing', 'wp-optimize'); ?></h3>
		<div class="wpo-fieldgroup">
			<fieldset>
				<label class="wpo-label__bold" for="exclude_css">
					<?php _e('Any CSS files that match the paths below will be completely ignored.', 'wp-optimize'); ?>
					<br/><?php _e('Use this if you are having issues with a specific CSS file', 'wp-optmize'); ?>
					<b tabindex="0" data-tooltip="<?php esc_attr_e('Any file present here will be loaded normally by WordPress', 'wp-optimize');?>"><span class="dashicons dashicons-editor-help"></span></b>
				</label>
				<textarea
					name="exclude_css"
					rows="7" cols="50"
					id="exclude_css"
					class="large-text code"
					placeholder="ex: /bootstrap.css"
				><?php echo esc_textarea($wpo_minify_options['exclude_css']);?></textarea>
				<br>
				<?php _e('Some files known for causing issues when combined / minified are excluded by default.', 'wp-optimize'); ?> <?php _e('You can see / edit them in the Advanced tab.', 'wp-optimize'); ?>
			</fieldset>
		</div>

		<h3><?php _e('Load the following CSS files asynchronously', 'wp-optimize'); ?></h3>
		<div class="wpo-fieldgroup">
			<fieldset>
				<label class="wpo-label__bold" for="async_css">
					<?php _e('Any CSS files that match the paths below will be loaded asynchronously.', 'wp-optimize'); ?><br>
					<?php _e('Use this if you have a completely independent stylesheet or would like to exclude stylesheets from page speed tests (PageSpeed Insights, GTMetrix...)', 'wp-optmize'); ?>
					<b tabindex="0" data-tooltip="<?php esc_attr_e("e.g. You may want to exclude 'fontawesome' or other libraries from the initial load", 'wp-optimize');?>"><span class="dashicons dashicons-editor-help"></span></b>
				</label>
				<textarea
					name="async_css"
					rows="7"
					cols="50"
					id="async_css"
					class="large-text code"
					placeholder="ex: /wp-content/themes/my-theme/css/custom-font.css"
				><?php echo $wpo_minify_options['async_css']; ?></textarea>
			</fieldset>
		</div>

		<?php if (WP_OPTIMIZE_SHOW_MINIFY_ADVANCED) : ?>
			<h3><?php _e('Enable asynchronous CSS', 'wp-optimize'); ?></h3>
			<div class="wpo-fieldgroup">
				<fieldset>
					<label for="loadcss">
						<input
							name="loadcss"
							type="checkbox"
							id="loadcss"
							value="1"
							<?php echo checked($wpo_minify_options['loadcss']); ?>
						>
						<?php _e('Load all CSS files asynchronously', 'wp-optimize'); ?>
						<b tabindex="0" data-tooltip="<?php _e('Note that inline CSS won\'t work if this is active', 'wp-optimize');?>"><span class="dashicons dashicons-editor-help"></span> </b>
					</label>
					<p>
						<?php _e('If you have multiple css files per media type, they may load out of order and break your design when loaded asynchronously.', 'wp-optimize'); ?>
					</p>
				</fieldset>
			</div>
		<?php endif; ?>

		<?php if (WP_OPTIMIZE_SHOW_MINIFY_ADVANCED) : ?>
			<h3>
				<?php _e('Critical path CSS', 'wp-optimize'); ?>
			</h3>
			<div class="wpo-fieldgroup">
				<fieldset>
					<label class="wpo-label__bold" for="critical_path_css"><?php _e('Fallback CSS', 'wp-optimize'); ?></label>
					<textarea
						name="critical_path_css"
						rows="7"
						cols="50"
						id="critical_path_css" class="large-text code"
						placeholder=".css-code { display: block; }"
					><?php echo $wpo_minify_options['critical_path_css']; ?></textarea>
				</fieldset>

				<fieldset>
					<label class="wpo-label__bold" for="critical_path_css_is_front_page"><?php _e('is_front_page (conditional)', 'wp-optimize'); ?> <b tabindex="0" data-tooltip="<?php esc_attr_e('This will be inlined after the above if your page matches the WP conditional is_front_page()', 'wp-optimize');?>"><span class="dashicons dashicons-editor-help"></span></b></label>
					<textarea
						name="critical_path_css_is_front_page"
						rows="7"
						cols="50"
						id="critical_path_css_is_front_page"
						class="large-text code" 
						placeholder=".css-code { display: block; }"
					><?php echo $wpo_minify_options['critical_path_css_is_front_page']; ?></textarea>
				</fieldset>
			</div>
		<?php endif; ?>
		
		<p class="submit">
			<input
				class="wp-optimize-save-minify-settings button button-primary"
				type="submit"
				value="<?php esc_attr_e('Save settings', 'wp-optimize'); ?>"
			>
			<img class="wpo_spinner" src="<?php echo esc_attr(admin_url('images/spinner-2x.gif')); ?>" alt="...">
			<span class="save-done dashicons dashicons-yes display-none"></span>
		</p>
	</form>
</div>
